/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.common;

import info.msxlaunchers.openmsx.common.NumericalEnum;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public final class Utils {
    public static int getNumber(String string) {
        int number = 0;
        try {
            number = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return number;
    }

    public static boolean isNumber(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static String getString(int value) {
        return Integer.toString(value);
    }

    public static String getString(long value) {
        return Long.toString(value);
    }

    public static String getEnumValue(NumericalEnum numericalEnum) {
        int value = 0;
        if (numericalEnum != null) {
            value = numericalEnum.getValue();
        }
        return Utils.getString(value);
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().isEmpty();
    }

    public static String resetIfEmpty(String string) {
        return Utils.isEmpty(string) ? null : string;
    }

    public static boolean equalStrings(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    public static String[] getSortedCaseInsensitiveArray(Set<String> set) {
        Objects.requireNonNull(set);
        return set.stream().sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.toList()).toArray(new String[set.size()]);
    }

    public static Set<String> getSortedCaseInsensitiveSet(Set<String> set) {
        Objects.requireNonNull(set);
        TreeSet<String> sortedSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        sortedSet.addAll(set);
        return sortedSet;
    }
}

